﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;

namespace VIRP_WEB.Custom.EFR
{
    public partial class ReferralContactLogs : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                GridViewEFRReferralContacts.Sort("ReferralId", SortDirection.Descending);
                HiddenFieldClearFlag.Value = "0";
            }

            ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Contact Logs > All Contacts";

            SetupCommonDataSourceParameters();
        }

        private void SetupCommonDataSourceParameters()
        {
            ObjectDataSourceEFRContacts.SelectParameters["CURRENT_USER"].DefaultValue = CurrentUser;
            ObjectDataSourceEFRContacts.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = CurrentRegistryId.ToString();
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            TextBoxSearchCriteria.Text = String.Empty;
            HiddenFieldClearFlag.Value = "1";            
        }

        protected void ButtonOK_Clear(object sender, EventArgs e)
        {
            GridViewEFRReferralContacts.PageIndex = 0;
            HiddenFieldClearFlag.Value = "0";

            ObjectDataSourceEFRContacts.SelectParameters["PATIENT_LAST_NAME"].DefaultValue = TextBoxSearchCriteria.Text.Trim();
        }

        public void Contacts_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRReferralContacts.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRReferralContacts.SelectedValue);
                //calling the right page for different order lab order type
                Response.Redirect(string.Format("ReferralContactLog.aspx?referralId={0}", id));
            }
        }
    }
}